// { dg-do run { xfail { ! arm-*-*eabi } } }

// catching a pointer to class by reference prohibits derived->base
// transformation.   The generic C++ ABI gets this wrong.  ARM EABI
// gets this right, except for exception specifications where a bug is
// acknowledged. 

#include <stdio.h>

struct A {};

struct B : A {};

int Foo ()
{
  B b;
  
  try
    {
      throw &b;
    }
  catch (A *&a)  // { dg-bogus "earlier handler" "" { xfail { ! arm-*-*eabi } } }
    {
      printf ("fail, caught A*&%p\n", a);
      return 1;
    }
  catch (B *&b)  // { dg-bogus "will be caught" "" { xfail { ! arm-*-*eabi } } }
    {
      printf ("pass, caught B*&%p\n", b);
    }
  catch (...)
    {
      printf ("fail, caught ...");
      return 2;
    }
  try
    {
      throw &b;
    }
  catch (A *a) // { dg-warning "by earlier handler" }
    {
      printf ("pass, caught A*%p\n", a);
    }
  catch (B *b) // { dg-warning "will be caught" }
    {
      printf ("fail, caught B*%p\n", b);
      return 3;
    }
  catch (...)
    {
      printf ("fail, caught ...");
      return 4;
    }
  return 0;
}


int main ()
{
  return Foo ();
}
