// { dg-do run { xfail { ! arm-*-*eabi } } }

// catching a pointer to class by reference prohibits derived->base
// transformation.   The generic C++ ABI gets this wrong.  ARM EABI
// gets this right, except for exception specifications where a bug is
// acknowledged. 

#include <stdio.h>
#include <exception>
#include <stdlib.h>

struct A {};

struct B : A {};

B b;

void One () throw (A *&)
{
  throw &b;
}

void Two () throw (A *&, B *&)
{
  throw &b;
}

void Three () throw (A *)
{
  throw &b;
}

int Foo (void (*fn)())
{
  try
    {
      fn ();
    }
  catch (B *b)
    {
      printf ("pass, caught B*%p\n", b);
    }
  catch (...)
    {
      printf ("fail, caught ...");
      return 1;
    }
  return 0;
}

void handler ()
{
  printf ("pass, got unexpected exception\n");
  exit (0);
}

int main ()
{
  if (Foo (&Three))
    return 1;

  if (Foo (&Two))
    return 2;

  std::set_unexpected (handler);
  if (Foo (&One))
    return 3;
  printf ("fail, did not get unexpected exception\n");
  return 4;
}
