/* Check that we correctly expand out-of-range branches */
/* { dg-do run } */
/* { dg-options "-O2 -mabi=32 -fPIC" } */

#include <stdlib.h>

/* This is weak so the compiler cannot assume that calls from this TU
   necessarily arrive here.   And hence that $gp may be clobbered in
   o32 and o64 ABIs.  */

void __attribute__ ((weak)) Foo (int i)
{
  static int once = 0;

  if (!i && once++)
    exit (0);

#if (_ABIO32 || _ABIO64)
  /* Clobber $gp */
  __asm volatile ("li $gp,0");
#endif
}

#define N1(X)  (Foo (X))
#define N2(X)  (N1 (X), N1 (X+(1<<0)))
#define N3(X)  (N2 (X), N2 (X+(1<<1)))
#define N4(X)  (N3 (X), N3 (X+(1<<2)))
#define N5(X)  (N4 (X), N4 (X+(1<<3)))
#define N6(X)  (N5 (X), N5 (X+(1<<4)))
#define N7(X)  (N6 (X), N6 (X+(1<<5)))
#define N8(X)  (N7 (X), N7 (X+(1<<6)))
#define N9(X)  (N8 (X), N8 (X+(1<<7)))
#define N10(X)  (N9 (X), N9 (X+(1<<8)))
#define N11(X)  (N10 (X), N10 (X+(1<<9)))
#define N12(X)  (N11 (X), N11 (X+(1<<10)))
#define N13(X)  (N12 (X), N12 (X+(1<<11)))
#define N14(X)  (N13 (X), N13 (X+(1<<12)))

int main (void)
{
  while (1)
    N14 (0);
  return 0;
}
