#******************************************************************************
#* ====================================================
#* Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
#*
#* Developed at SunPro, a Sun Microsystems, Inc. business.
#* Permission to use, copy, modify, and distribute this
#* software is freely granted, provided that this notice 
#* is preserved.
#* ====================================================
#*
#* Copyright (c) 2004 Freescale Semiconductor, Inc
#* All rights reserved.
#*
#* Redistribution and use in source and binary forms, with or without
#* modification, are permitted provided that the following conditions are met:
#*     * Redistributions of source code must retain the above copyright
#*       notice, this list of conditions and the following disclaimer.
#*     * Redistributions in binary form must reproduce the above copyright
#*       notice, this list of conditions and the following disclaimer in the
#*       documentation and/or other materials provided with the distribution.
#*     * Neither the name of Freescale Semiconductor nor the
#*       names of its contributors may be used to endorse or promote products
#*       derived from this software without specific prior written permission.
#*
#* THIS SOFTWARE IS PROVIDED BY Freescale Semiconductor ``AS IS'' AND ANY
#* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
#* DISCLAIMED. IN NO EVENT SHALL Freescale Semiconductor BE LIABLE FOR ANY
#* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
#* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
#* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#*
#*  Functions:    atan
#*
#*  Description:  implements floating point double precision
#*                software emulation for atan() functions
#*                from MATH library (libmath)
#*
#*  Notes:        none
#*
#******************************************************************************

#include <powerpc/asm.h>

        .file	"s_atan.S"

#define r0 0
#define r1 1
#define r2 2
#define r3 3
#define r4 4
#define r5 5
#define r6 6
#define r7 7
#define r8 8
#define r9 9
#define r10 10
#define r11 11
#define r12 12
#define r13 13
#define r14 14
#define r15 15
#define r16 16
#define r17 17
#define r18 18
#define r19 19
#define r20 20
#define r21 21
#define r22 22
#define r23 23
#define r24 24
#define r25 25
#define r26 26
#define r27 27
#define r28 28
#define r29 29
#define r30 30
#define r31 31

#define lt0 0
#define gt0 1
#define eq0 2
#define so0 3
#define lt1 4
#define gt1 5
#define eq1 6
#define so1 7
#define lt2 8
#define gt2 9
#define eq2 10
#define so2 11
#define lt3 12
#define gt3 13
#define eq3 14
#define so3 15
#define lt4 16
#define gt4 17
#define eq4 18
#define so4 19
#define lt5 20
#define gt5 21
#define eq5 22
#define so5 23
#define lt6 24
#define gt6 25
#define eq6 26
#define so6 27
#define lt7 28
#define gt7 29
#define eq7 30
#define so7 31

	.extern	__muldf3
	.extern	__divdf3
	.extern	__adddf3
	.extern	__subdf3

	.section	".text"

/*******************************************
*	fast implementation of atan        *
*******************************************/
	.align  2
ENTRY(atan)
#ifdef _SOFT_DOUBLE
#define ix r11
#define hx r3
#define lx r4

#define sign 21
#define ahi 22
#define alo 23
#define bhi 24
#define blo 25
#define whi 26
#define wlo 27
#define xhi 28
#define xlo 29
#define zhi 30
#define zlo 31

	clrlwi	ix,	hx,	1

	lis	r5,	0x3e20
	lis	r6,	0x4410

	cmpw	cr5,	ix,	r5
	cmpw	cr6,	ix,	r6

	bltlr-	cr5
	bge-	cr6,	L(atan_big_argument)

	stwu	r1,	-64(r1)
	mflr	r0
	stw	r0,	68(r1)
	stmw	r21,	8(r1)			# make stack frame here

	andis.	sign,	hx,	0x8000

	lis	r7,	0x3fdc
	lis	r8,	0x3fe6
	lis	r9,	0x3ff3
	lis	r10,	0x4003
	ori	r10,	r10,	0x8000

	cmpw	cr0,	ix,	r7
	cmpw	cr1,	ix,	r8
	cmpw	cr5,	ix,	r9
	cmpw	cr6,	ix,	r10

	blt-	cr0,	L(atan_range0)
	mr	hx,	ix	
	blt-	cr1,	L(atan_range1)
	blt-	cr5,	L(atan_range2)
	blt-	cr6,	L(atan_range3)

	mr	r5,	r3
	mr	r6,	r4
	lis	r3,	0xbff0
	li	r4,	0
	bl	__divdf3@plt

	lis	ahi,	0x3ff9
	ori	ahi,	ahi,	0x21fb
	lis	alo,	0x5444
	ori	alo,	alo,	0x2d18

	lis	bhi,	0x3c91
	ori	bhi,	bhi,	0xa626
	lis	blo,	0x3314
	ori	blo,	blo,	0x5c07

L(atan_poly_calc):
	mr	r5,	r3
	mr	xhi,	r3
	mr	r6,	r4
	mr	xlo,	r4
	bl	__muldf3@plt			# z = x * x

	mr	r5,	r3
	mr	zhi,	r3
	mr	r6,	r4
	mr	zlo,	r4
	bl	__muldf3@plt			# w = z * z

	mr	whi,	r3
	mr	wlo,	r4

	lis	r5,	0x3f90
	ori	r5,	r5,	0xad3a
	lis	r6,	0xe322
	ori	r6,	r6,	0xda11
	bl	__muldf3@plt			# w * at10

	lis	r5,	0x3fa9
	ori	r5,	r5,	0x7b4b
	lis	r6,	0x2476
	ori	r6,	r6,	0x0deb
	bl	__adddf3@plt			# at8 + w*at10

	mr	r5,	whi
	mr	r6,	wlo
	bl	__muldf3@plt			# w * (at8+w*at10)

	lis	r5,	0x3fb1
	ori	r5,	r5,	0x0d66
	lis	r6,	0xa0d0
	ori	r6,	r6,	0x3d51
	bl	__adddf3@plt			# at6 + w*(at8+w*at10)

	mr	r5,	whi
	mr	r6,	wlo
	bl	__muldf3@plt			# w * (at6+w*(at8+w*at10))

	lis	r5,	0x3fb7
	ori	r5,	r5,	0x45cd
	lis	r6,	0xc54c
	ori	r6,	r6,	0x206e
	bl	__adddf3@plt			# at4 + w*(at6+w*(at8+w*at10))

	mr	r5,	whi
	mr	r6,	wlo
	bl	__muldf3@plt			# w * (at4+w*(at6+w*(at8+w*at10)))

	lis	r5,	0x3fc2
	ori	r5,	r5,	0x4924
	lis	r6,	0x9200
	ori	r6,	r6,	0x83ff
	bl	__adddf3@plt			# at2 + w*(at4+w*(at6+w*(at8+w*at10)))

	mr	r5,	whi
	mr	r6,	wlo
	bl	__muldf3@plt			# w * (at2+w*(at4+w*(at6+w*(at8+w*at10))))

	lis	r5,	0x3fd5
	ori	r5,	r5,	0x5555
	lis	r6,	0x5555
	ori	r6,	r6,	0x550d
	bl	__adddf3@plt			# at0 + w*(at2+w*(at4+w*(at6+w*(at8+w*at10))))

	mr	r5,	zhi
	mr	r6,	zlo
	bl	__muldf3@plt			# z * (at0+w*(at2+w*(at4+w*(at6+w*(at8+w*at10)))))
	mr	zhi,	r3
	mr	zlo,	r4			# store temporary in z

	mr	r3,	whi
	mr	r4,	wlo

	lis	r5,	0xbfa2
	ori	r5,	r5,	0xb444
	lis	r6,	0x2c6a
	ori	r6,	r6,	0x6c2f
	bl	__muldf3@plt			# w * at9

	lis	r5,	0xbfad
	ori	r5,	r5,	0xde2d
	lis	r6,	0x52de
	ori	r6,	r6,	0xfd9a
	bl	__adddf3@plt			# at7 + w*at9

	mr	r5,	whi
	mr	r6,	wlo
	bl	__muldf3@plt			# w * (at7+w*at9)

	lis	r5,	0xbfb3
	ori	r5,	r5,	0xb0f2
	lis	r6,	0xaf74
	ori	r6,	r6,	0x9a6d
	bl	__adddf3@plt			# at5 + w*(at7+w*at9)

	mr	r5,	whi
	mr	r6,	wlo
	bl	__muldf3@plt			# w * (at5+w*(at7+w*at9))

	lis	r5,	0xbfbc
	ori	r5,	r5,	0x71c6
	lis	r6,	0xfe23
	ori	r6,	r6,	0x1671
	bl	__adddf3@plt			# at3 + w*(at5+w*(at7+w*at9))

	mr	r5,	whi
	mr	r6,	wlo
	bl	__muldf3@plt			# w * (at3+w*(at5+w*(at7+w*at9)))

	lis	r5,	0xbfc9
	ori	r5,	r5,	0x9999
	lis	r6,	0x9998
	ori	r6,	r6,	0xebc4
	bl	__adddf3@plt			# at1 + w*(at3+w*(at5+w*(at7+w*at9)))

	mr	r5,	whi
	mr	r6,	wlo
	bl	__muldf3@plt			# w * (at1+w*(at3+w*(at5+w*(at7+w*a9))))

	mr	r5,	zhi
	mr	r6,	zlo
	bl	__adddf3@plt			# s1+s2

	mr	r5,	xhi
	mr	r6,	xlo
	bl	__muldf3@plt


	cmpwi	cr0,	ahi,	0
	beq-	cr0,	L(atan_argument_not_big)

	mr	r5,	bhi
	mr	r6,	blo
	bl	__subdf3@plt
	mr	r5,	xhi
	mr	r6,	xlo
	bl	__subdf3@plt
	mr	r5,	r3
	mr	r6,	r4
	mr	r3,	ahi
	mr	r4,	alo
	bl	__subdf3@plt			# atan(x) = a-((x*(s1+s2)-b)-x)

	or	r3,	r3,	sign		# atan(-x) = -atan(x)

L(atan_exit):
	lmw	r21,	8(r1)
	lwz	r0,	68(r1)
	mtlr	r0
	addi	r1,	r1,	+64
	blr

L(atan_range0):
	mr	xhi,	ix
	mr	xlo,	lx

	li	ahi,	0

	b	L(atan_poly_calc)

L(atan_range1):
	mr	hx,	ix
	mr	xhi,	ix
	mr	xlo,	lx
	lis	r5,	0x4000
	li	r6,	0
	bl	__adddf3@plt
	mr	zhi,	r3
	mr	zlo,	r4			# store temporary in z

	mr	r3,	xhi
	mr	r4,	xlo
	lis	r5,	0x4000
	li	r6,	0
	bl	__muldf3@plt
	lis	r5,	0x3ff0
	li	r6,	0
	bl	__subdf3@plt

	mr	r5,	zhi
	mr	r6,	zlo
	bl	__divdf3@plt			# x = (2*x-1)/(2+*x)

	lis	ahi,	0x3fdd
	ori	ahi,	ahi,	0xac67
	lis	alo,	0x0561
	ori	alo,	alo,	0xbb4f

	lis	bhi,	0x3c7a
	ori	bhi,	bhi,	0x2b7f
	lis	blo,	0x222f
	ori	blo,	blo,	0x65e2

	b	L(atan_poly_calc)

L(atan_range2):
	mr	hx,	ix
	mr	xhi,	ix
	mr	xlo,	lx
	lis	r5,	0x3ff0
	li	r6,	0
	bl	__adddf3@plt
	mr	zhi,	r3
	mr	zlo,	r4			# store temporary in z

	mr	r3,	xhi
	mr	r4,	xlo
	lis	r5,	0x3ff0
	li	r6,	0
	bl	__subdf3@plt

	mr	r5,	zhi
	mr	r6,	zlo
	bl	__divdf3@plt			# x = (x-1)/(x+1)

	lis	ahi,	0x3fe9
	ori	ahi,	ahi,	0x21fb
	lis	alo,	0x5444
	ori	alo,	alo,	0x2d18

	lis	bhi,	0x3c81
	ori	bhi,	bhi,	0xa626
	lis	blo,	0x3314
	ori	blo,	blo,	0x5c07

	b	L(atan_poly_calc)

L(atan_range3):
	mr	hx,	ix
	mr	xhi,	ix
	mr	xlo,	lx
	lis	r5,	0x3ff8
	li	r6,	0
	bl	__muldf3@plt
	lis	r5,	0x3ff0
	li	r6,	0
	bl	__adddf3@plt
	mr	zhi,	r3
	mr	zlo,	r4			# store temporary in z

	mr	r3,	xhi
	mr	r4,	xlo
	lis	r5,	0x3ff8
	li	r6,	0
	bl	__subdf3@plt

	mr	r5,	zhi
	mr	r6,	zlo
	bl	__divdf3@plt			# x = (x-1.5)/(1+1.5*x)

	lis	ahi,	0x3fef
	ori	ahi,	ahi,	0x730b
	lis	alo,	0xd281
	ori	alo,	alo,	0xf69b

	lis	bhi,	0x3c70
	ori	bhi,	bhi,	0x0788
	lis	blo,	0x7af0
	ori	blo,	blo,	0xcbbd

	b	L(atan_poly_calc)

L(atan_argument_not_big):
	mr	r5,	r3
	mr	r6,	r4
	mr	r3,	xhi
	mr	r4,	xlo
	bl	__subdf3@plt

	b	L(atan_exit)

L(atan_big_argument):
	lis	r5,	0x7ff0

	cmpw	cr5,	ix,	r5
	cmpwi	cr6,	lx,	0

	bgtlr-	cr5
	blt+	cr5,	L(atan_overflow)
	bnelr-	cr6

L(atan_overflow):
	andis.	r5,	hx,	0x8000		# get sign

	lis	hx,	0x3ff9
	ori	hx,	hx,	0x21fb
	lis	lx,	0x5444
	ori	lx,	lx,	0x2d18

	or	hx,	hx,	r5		# apply the sign

	blr
#else
#define hx r3
#define lx r4

#define ix r12

#define sign r0
#define s r3
#define x r4
#define a r7
/* Can't use `b' since it would replace the `b' branch mnemonic.  */
#define b_ r8
#define w r9
#define t r10
#define z r11

	clrlwi	ix,	hx,	1		# ix = |hx|
	evmergelo	x,	hx,	lx	# merge to 64 bit

	lis	r5,	0x3e20
	lis	r6,	0x4410

	cmpw	cr5,	ix,	r5		# check underflow
	cmpw	cr6,	ix,	r6		# check overflow

	bltlr-	cr5				# return inexact
	bge-	cr6,	L(atan_big_argument)

	andis.	sign,	hx,	0x8000		# get sign

	lis	r7,	0x3fdc
	lis	r8,	0x3fe6
	lis	r9,	0x3ff3
	lis	r10,	0x4003
	ori	r10,	r10,	0x8000

	cmpw	cr0,	ix,	r7
	cmpw	cr1,	ix,	r8
	cmpw	cr5,	ix,	r9
	cmpw	cr6,	ix,	r10

	blt-	cr0,	L(atan_poly_calc)
	evmergelo	x,	ix,	lx	# x = |x|
	blt-	cr1,	L(atan_range1)
	blt-	cr5,	L(atan_range2)
	blt-	cr6,	L(atan_range3)

	lis	r5,	0xbff0
	li	r6,	0
	evmergelo	t,	r5,r6		# t = -1.0
	efddiv	x,	t,	x		# x = -1.0/x

	lis	r5,	0x3ff9
	ori	r5, r5,	0x21fb
	lis	r6,	0x5444
	ori	r6, r6,	0x2d18
	evmergelo	a,	r5,r6		# a = !!!

	lis	r5,	0x3c91
	ori	r5, r5,	0xa626
	lis	r6,	0x3314
	ori	r6, r6,	0x5c07
	evmergelo	b_,	r5,r6		# b = !!!

L(atan_poly_calc):
	efdmul	z,	x,	x		# z = x * x
	efdmul	w,	z,	z		# w = z * z

	lis	r5,	0x3f90
	ori	r5, r5,	0xad3a
	lis	r6,	0xe322
	ori	r6, r6,	0xda11
	evmergelo	t,	r5,r6		# t = at10
	efdmul	s,	w,	t		# s = w * at10

	lis	r5,	0x3fa9
	ori	r5, r5,	0x7b4b
	lis	r6,	0x2476
	ori	r6, r6,	0x0deb
	evmergelo	t,	r5,r6		# t = at8
	efdadd	s,	s,	t		# s = at8 + w*at10
	efdmul	s,	s,	w		# s = w * (at8+w*at10)

	lis	r5,	0x3fb1
	ori	r5, r5,	0x0d66
	lis	r6,	0xa0d0
	ori	r6, r6,	0x3d51
	evmergelo	t,	r5,r6		# t = at6
	efdadd	s,	s,	t		# s = at6 + w*(at8+w*at10)
	efdmul	s,	s,	w		# s = w * (at6+w*(at8+w*at10))

	lis	r5,	0x3fb7
	ori	r5, r5,	0x45cd
	lis	r6,	0xc54c
	ori	r6, r6,	0x206e
	evmergelo	t,	r5,r6		# t = at4
	efdadd	s,	s,	t		# s = at4 + w*(at6+w*(at8+w*at10))
	efdmul	s,	s,	w		# s = w * (at4+w*(at6+w*(at8+w*at10)))

	lis	r5,	0x3fc2
	ori	r5, r5,	0x4924
	lis	r6,	0x9200
	ori	r6, r6,	0x83ff
	evmergelo	t,	r5,r6		# t = at2
	efdadd	s,	s,	t		# s = at2 + w*(at4+w*(at6+w*(at8+w*at10)))
	efdmul	s,	s,	w		# s = w * (at2+w*(at4+w*(at6+w*(at8+w*at10))))

	lis	r5,	0x3fd5
	ori	r5, r5,	0x5555
	lis	r6,	0x5555
	ori	r6, r6,	0x550d
	evmergelo	t,	r5,r6		# t = at0
	efdadd	s,	s,	t		# s = at0 + w*(at2+w*(at4+w*(at6+w*(at8+w*at10))))
	efdmul	z,	z,	s		# z = z * (at0+w*(at2+w*(at4+w*(at6+w*(at8+w*at10)))))

	lis	r5,	0xbfa2
	ori	r5, r5,	0xb444
	lis	r6,	0x2c6a
	ori	r6, r6,	0x6c2f
	evmergelo	t,	r5,r6		# t = at9
	efdmul	s,	w,	t		# s = w * at9

	lis	r5,	0xbfad
	ori	r5, r5,	0xde2d
	lis	r6,	0x52de
	ori	r6, r6,	0xfd9a
	evmergelo	t,	r5,r6		# t = at7
	efdadd	s,	s,	t		# s = at7 + w*at9
	efdmul	s,	s,	w		# s = w * (at7+w*at9)

	lis	r5,	0xbfb3
	ori	r5, r5,	0xb0f2
	lis	r6,	0xaf74
	ori	r6, r6,	0x9a6d
	evmergelo	t,	r5,r6		# t = at5
	efdadd	s,	s,	t		# s = at5 + w*(at7+w*at9)
	efdmul	s,	s,	w		# s = w * (at5+w*(at7+w*at9))

	lis	r5,	0xbfbc
	ori	r5, r5,	0x71c6
	lis	r6,	0xfe23
	ori	r6, r6,	0x1671
	evmergelo	t,	r5,r6		# t = at3
	efdadd	s,	s,	t		# s = at3 + w*(at5+w*(at7+w*at9))
	efdmul	s,	s,	w		# s = w * (at3 + w*(at5+w*(at7+w*at9)))

	lis	r5,	0xbfc9
	ori	r5, r5,	0x9999
	lis	r6,	0x9998
	ori	r6, r6,	0xebc4
	evmergelo	t,	r5,r6		# t = at1
	efdadd	s,	s,	t		# s = at1 + w*(at3+w*(at5+w*(at7+w*at9)))
	efdmul	s,	s,	w		# s = w * (at1 + w*(at3+w*(at5+w*(at7+w*at9))))

	efdadd	s,	s,	z		# s = s + z
	efdmul	s,	s,	x		# s = x * s

	blt-	cr0,	L(atan_argument_not_big)

	efdsub	s,	s,	b_		# s = s - b
	efdsub	s,	s,	x		# s = s - x
	efdsub	x,	a,	s		# r4 = a - s

	evmergelohi	hx,	lx,	x	# split result
	or	hx,	hx,	sign		# atan(-x) = -atan(x)
	blr

L(atan_range1):
	lis	r5,	0x4000
	lis	r6,	0x3ff0
	li	r7,	0
	evmergelo	r8,	r5,r7		# r8 = 2.0
	evmergelo	r9,	r6,r7		# r9 = 1.0

	efdmul	r10,	r8,	x		# r10 = 2.0 * x
	efdsub	r10,	r10,	r9		# r10 = 2x-1
	efdadd	r11,	r8,	x		# r11 = 2+x
	efddiv	x,	r10,	r11		# x = (2*x-1)/(2+*x)

	lis	r5,	0x3fdd
	ori	r5, r5,	0xac67
	lis	r6,	0x0561
	ori	r6, r6,	0xbb4f
	evmergelo	a,	r5,r6		# a = !!!

	lis	r5,	0x3c7a
	ori	r5, r5,	0x2b7f
	lis	r6,	0x222f
	ori	r6, r6,	0x65e2
	evmergelo	b_,	r5,r6		# b = !!!

	b	L(atan_poly_calc)

L(atan_range2):
	lis	r5,	0x3ff0
	li	r6,	0
	evmergelo	r7,	r5,r6		# r7 = 1.0

	efdsub	r10,	x,	r7
	efdadd	r11,	x,	r7
	efddiv	x,	r10,	r11		# x = (x-1)/(x+1)

	lis	r5,	0x3fe9
	ori	r5, r5,	0x21fb
	lis	r6,	0x5444
	ori	r6, r6,	0x2d18
	evmergelo	a,	r5,r6		# a = !!!

	lis	r5,	0x3c81
	ori	r5, r5,	0xa626
	lis	r6,	0x3314
	ori	r6, r6,	0x5c07
	evmergelo	b_,	r5,r6		# b = !!!

	b	L(atan_poly_calc)

L(atan_range3):
	lis	r5,	0x3ff8
	lis	r6,	0x3ff0
	li	r7,	0
	evmergelo	r8,	r5,r7		# r8 = 1.5
	evmergelo	r9,	r6,r7		# r9 = 1.0

	efdsub	r10,	x,	r8		# r10 = x-1.5
	efdmul	r11,	x,	r8		# r11 = 1.5*x
	efdadd	r11,	r11,	r9		# r11 = 1+1.5x
	efddiv	x,	r10,	r11		# x = (x-1.5)/(1+1.5*x)

	lis	r5,	0x3fef
	ori	r5, r5,	0x730b
	lis	r6,	0xd281
	ori	r6, r6,	0xf69b
	evmergelo	a,	r5,r6		# a = !!!

	lis	r5,	0x3c70
	ori	r5, r5,	0x0788
	lis	r6,	0x7af0
	ori	r6, r6,	0xcbbd
	evmergelo	b_,	r5,r6		# b = !!!

	b	L(atan_poly_calc)

L(atan_argument_not_big):
	efdsub	x,	x,	s		# x = x - s
	evmergelohi	hx,	lx,	x	# split result up
	blr

L(atan_big_argument):
	lis	r5,	0x7ff0

	cmpw	cr5,	ix,	r5
	cmpwi	cr6,	lx,	0

	bgtlr-	cr5
	blt+	cr5,	L(atan_overflow)
	bnelr-	cr6

L(atan_overflow):
	andis.	r5,	hx,	0x8000		# get sign

	lis	hx,	0x3ff9
	ori	hx, hx,	0x21fb
	lis	lx,	0x5444
	ori	lx, lx,	0x2d18

	or	hx,	hx,	r5		# apply the sign

	blr
#endif
END(atan)

#ifdef NO_LONG_DOUBLE

#endif
